package com.vf106.tools.activity;

import android.content.Intent;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;

import com.vf106.tools.R;
import com.vf106.tools.activity.base.BaseActivity;
import com.vf106.tools.utils.Constants;
import com.vf106.tools.utils.TtsManager;

public class TtsVideoActivity extends BaseActivity implements View.OnClickListener {
    private LinearLayout llRight;
    private LinearLayout llWrong;
    private int position;
    private int state;
    private String name;
    private boolean isStart = false;

    @Override
    protected void setContentView() {
        setContentView(R.layout.activity_tts);
    }

    @Override
    protected void initViews() {
        Intent intent = getIntent();
        position = intent.getIntExtra("position", 0);
        name = intent.getStringExtra("name");
        state = intent.getIntExtra("state", 0);

        llRight = findViewById(R.id.ll_right);
        llWrong = findViewById(R.id.ll_wrong);

        Button btnStart = findViewById(R.id.btnStart);
        btnStart.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startVideo();
            }
        });
    }

    public void startVideo() {
        isStart = true;
        new Thread(() -> {
            while (isStart) {
                runOnUiThread(() -> TtsManager.getInstance(TtsVideoActivity.this).say("This is the factory test voice, please turn on the maximum volume and press the test."));

                try {
                    Thread.sleep(10000);
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }

        }).start();
    }

    @Override
    protected void setTitle() {

    }

    @Override
    protected void setListener() {
        llRight.setOnClickListener(this);
        llWrong.setOnClickListener(this);
    }

    @Override
    protected void initViewData() {

    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.ll_right:
                state = 1;
                setIntentData();
                break;
            case R.id.ll_wrong:
                state = 2;
                setIntentData();
                break;
        }
    }

    public void setIntentData() {
        Intent intent = new Intent();
        intent.putExtra("name", name);
        intent.putExtra("state", state);
        intent.putExtra("position", position);
        setResult(Constants.resultCode, intent);
        finish();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        isStart = false;
    }

    @Override
    protected void onPause() {
        super.onPause();
        isStart = false;
    }
}
